/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.fsp.cmdhelpers.FspFileOpenResponse;
import com.ibm.hsc.fsp.cmdhelpers.FspQueryData;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.console.OmHostsInfo;
import com.ibm.hsc.objmgr.sys.OmSysMgr;
import com.ibm.hsc.rep.v50.R50ComputerSystem;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt8;

public class OmCecBpcIpPush {
    private static final int FRAME_FILE_ID = 20;
    private static final long FRAME_FILE_SUBID = 0L;
    private static final short FOR_WRITE = 2;
    public static final int BPA_IP_EMPTY_PACKET = 1;
    public static final int BPA_IP_NOT_DHCP_SERVER = 2;
    public static final int BPA_IP_TIMESATMP_UP_TO_DATE = 3;
    public static final int BPA_IP_CEC_NOT_READY = 4;
    public static final int BPA_IP_FSP_COMMAND_ERROR = 5;
    public static final int BPA_IP_NO_CEC_LOCK = 6;
    public static final int BPA_IP_INVALID_FSP_VERSION = 7;
    private long mLastPushTime = 0L;
    private boolean mGetBpcIpPushLock = false;
    private FspLockHelper mLockHelper = null;
    private OmCecMgr mCecMgr = null;

    OmCecBpcIpPush(OmCecMgr omCecMgr) {
        this.mCecMgr = omCecMgr;
    }

    void initialize() {
        if (!OmHostsInfo.isEnabled()) {
            System.out.println("not dhcp server no push");
            return;
        }
        this.mLockHelper = new FspLockHelper(this.mCecMgr.getFspLockMgr(), 64);
        try {
            this.mLockHelper.lock();
            this.mGetBpcIpPushLock = true;
            this.pushDownBpcIpInfo();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    void disconnect() {
        this.mLastPushTime = 0L;
        this.mGetBpcIpPushLock = false;
        this.mLockHelper = null;
    }

    static int pushDownBpcIpInfo2AllCecs(Hashtable hashtable) {
        System.err.println("pushing down bpc ip info to all cecs");
        if (!OmHostsInfo.isEnabled()) {
            System.out.println("not dhcp server no push");
            return 2;
        }
        Vector vector = OmHostsInfo.buildFilePackage();
        long l = (Long)vector.elementAt(0);
        byte[] byArray = (byte[])vector.elementAt(1);
        if (vector == null || vector.size() < 2) {
            System.out.println("invalid ip file packet:" + vector);
            return 1;
        }
        l = (Long)vector.elementAt(0);
        byArray = (byte[])vector.elementAt(1);
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            OmSysMgr omSysMgr = (OmSysMgr)enumeration.nextElement();
            if (!(omSysMgr instanceof OmCecMgr)) continue;
            OmCecMgr omCecMgr = (OmCecMgr)omSysMgr;
            try {
                omCecMgr.pushDownBpcIpInfo(byArray, l);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return 0;
    }

    int pushDownBpcIpInfo() {
        System.err.println("pushing down bpc ip info for " + this.mCecMgr.getCecName());
        if (!OmHostsInfo.isEnabled()) {
            System.out.println("not dhcp server no push");
            return 2;
        }
        Vector vector = OmHostsInfo.buildFilePackage();
        if (vector == null || vector.size() < 2) {
            System.out.println("invalid ip file packet:" + vector);
            return 1;
        }
        long l = (Long)vector.elementAt(0);
        byte[] byArray = (byte[])vector.elementAt(1);
        return this.pushDownBpcIpInfo(byArray, l);
    }

    synchronized int pushDownBpcIpInfo(byte[] byArray, long l) {
        UnsignedInt8[] unsignedInt8Array;
        System.out.println("enter pushDownBpcIpInfo");
        if (!this.mGetBpcIpPushLock) {
            System.out.println("doesn't have the bpc ip push lock");
            return 6;
        }
        if (this.mLastPushTime >= l) {
            System.out.println("lastPushTime " + this.mLastPushTime);
            System.out.println("timestamp " + l);
            System.out.println("do not push bpa ip table for " + this.mCecMgr.getCecName());
            return 3;
        }
        int n = this.mCecMgr.getCmdMgr().getCmdState();
        if (n != 5 && n != 0) {
            System.out.println("invalid cec cmd state for bpc ip push " + n);
            return 4;
        }
        boolean bl = false;
        FspQueryData fspQueryData = this.mCecMgr.getCmdMgr().getQueryData();
        if (fspQueryData.getMajorVersion().intValue() == 4 && fspQueryData.getMinorVersion().intValue() == 0) {
            bl = true;
        } else {
            System.out.println("major/minor " + fspQueryData.getMajorVersion() + "/" + fspQueryData.getMinorVersion());
            try {
                unsignedInt8Array = (UnsignedInt8[])this.mCecMgr.getObject().getProperty(R50ComputerSystem.Index_Capability);
                if ((unsignedInt8Array[5].intValue() & 4) != 0) {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (!bl) {
            System.out.println("invalid fsp version for bpc ip push ");
            return 7;
        }
        System.out.println("pushing down bpa ip table");
        try {
            unsignedInt8Array = this.mCecMgr.getCmdHelper();
            FspFileOpenResponse fspFileOpenResponse = unsignedInt8Array.openFile(20, 0L, (short)2, (short)0, 0L, byArray.length);
            if (fspFileOpenResponse != null) {
                long l2 = unsignedInt8Array.writeFile(20, 0L, 0L, byArray.length, byArray);
                if (l2 != (long)byArray.length) {
                    unsignedInt8Array.closeFile(20, 0L, 255L);
                } else {
                    unsignedInt8Array.closeFile(20, 0L, 1L);
                }
                this.mLastPushTime = l;
            }
            return 0;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 5;
        }
    }
}

